/*
 * Decompiled with CFR 0.152.
 */
package pub.pigeon.yggdyy.hexcreating.create.spout;

import at.petrak.hexcasting.common.recipe.BrainsweepRecipe;
import at.petrak.hexcasting.common.recipe.HexRecipeStuffRegistry;
import io.github.fabricators_of_create.porting_lib.fluids.FluidStack;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.class_1299;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2960;
import net.minecraft.class_5819;
import org.jetbrains.annotations.Nullable;
import pub.pigeon.yggdyy.hexcreating.fluids.SoulFluid;

public class FlayMindBySpout {
    @Nullable
    public static List<BrainsweepRecipe> RECIPES = null;
    private static final class_5819 RANDOM = class_5819.method_43047();

    public static void checkRecipes(class_1937 world) {
        if (RECIPES == null) {
            RECIPES = world.method_8433().method_8126().stream().filter(recipe -> recipe.method_17716().equals((Object)HexRecipeStuffRegistry.BRAINSWEEP_TYPE)).map(recipe -> (BrainsweepRecipe)recipe).collect(Collectors.toList());
        }
    }

    public static List<BrainsweepRecipe> getSuitableRecipes(class_1937 world, class_2248 block, class_2960 entityId) {
        return RECIPES.stream().filter(brainsweepRecipe -> {
            boolean checkBlock = brainsweepRecipe.blockIn().test(block.method_9564());
            boolean checkEntity = class_1299.method_5890((class_1299)brainsweepRecipe.entityIn().exampleEntity(world).method_5864()).equals((Object)entityId);
            boolean checkOutput = !brainsweepRecipe.result().method_26204().method_8389().equals(class_1802.field_8162);
            return checkBlock && checkEntity && checkOutput;
        }).collect(Collectors.toList());
    }

    public static boolean isItemFlayMindAble(class_1937 world, class_1799 stack) {
        FlayMindBySpout.checkRecipes(world);
        class_1792 class_17922 = stack.method_7909();
        if (class_17922 instanceof class_1747) {
            class_1747 item = (class_1747)class_17922;
            class_2248 block = item.method_7711();
            for (BrainsweepRecipe r : RECIPES) {
                if (!r.blockIn().test(block.method_9564())) continue;
                return true;
            }
        }
        return false;
    }

    public static long getItemRequiredSoul(class_1937 world, class_1799 stack, FluidStack providedFluid) {
        FlayMindBySpout.checkRecipes(world);
        if (FlayMindBySpout.isItemFlayMindAble(world, stack) && providedFluid.getFluid() instanceof SoulFluid && providedFluid.hasTag() && providedFluid.getTag().method_10545(SoulFluid.ID_KEY)) {
            class_2960 entityId = class_2960.method_12829((String)providedFluid.getTag().method_10558(SoulFluid.ID_KEY));
            if (entityId == null) {
                return -1L;
            }
            List<BrainsweepRecipe> suit = FlayMindBySpout.getSuitableRecipes(world, ((class_1747)stack.method_7909()).method_7711(), entityId);
            if (suit == null || suit.size() < 1) {
                return -1L;
            }
            long ret = 0L;
            for (BrainsweepRecipe r : suit) {
                ret += r.mediaCost();
            }
            return (ret = ret / (long)suit.size() / 10000L * 81L) <= providedFluid.getAmount() ? ret : -1L;
        }
        return -1L;
    }

    @Nullable
    public static class_1799 flayMindItem(class_1937 world, long requiredAmount, class_1799 stack, FluidStack providedFluid) {
        FlayMindBySpout.checkRecipes(world);
        if (FlayMindBySpout.isItemFlayMindAble(world, stack) && providedFluid.getFluid() instanceof SoulFluid && providedFluid.hasTag() && providedFluid.getTag().method_10545(SoulFluid.ID_KEY)) {
            class_2960 entityId = class_2960.method_12829((String)providedFluid.getTag().method_10558(SoulFluid.ID_KEY));
            if (entityId == null) {
                return null;
            }
            List<BrainsweepRecipe> suit = FlayMindBySpout.getSuitableRecipes(world, ((class_1747)stack.method_7909()).method_7711(), entityId);
            if (suit == null || suit.size() < 1) {
                return null;
            }
            long ret = 0L;
            for (BrainsweepRecipe r : suit) {
                ret += r.mediaCost();
            }
            if ((ret = ret / (long)suit.size() / 10000L * 81L) != requiredAmount) {
                return null;
            }
            int cur = RANDOM.method_39332(0, suit.size() - 1);
            providedFluid.shrink(requiredAmount);
            stack.method_7971(1);
            return suit.get(cur).result().method_26204().method_8389().method_7854();
        }
        return null;
    }
}

